<?php
/*
Plugin Name:SeoHide
Plugin URI: http://alkoweb.ru/seohide-plugin-wodpress/
Description: Plugin for hiding external links
Version: 1.2.0
Author: Petrozavodsky Vladimir
Author URI: http://alkoweb.ru/
Text Domain: vp-seo-hide
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'vp_seo_hide' ) ) {
	class vp_seo_hide {

		protected $settings;
		protected $text_domain;
		protected $option_prefix;

		function __construct() {
			add_action('plugins_loaded', array($this,'text_domine'));
			$this->set_text_domain( 'vp-seo-hide' );
			$this->set_option_prefix( 'seohide_' );
			$this->load_dependencies();
			$this->settings = array(
				'basename' => plugin_basename( __FILE__ ),
				'path'     => plugin_dir_path( __FILE__ ),
				'url'      => plugin_dir_url( __FILE__ ),
			);
			add_action( 'wp_enqueue_scripts', array( &$this, 'load_scripts' ) );
			add_filter( 'the_content', array( &$this, 'search_links' ) );
			add_filter( 'get_comment_author_link', array( $this, 'hide_comment_author_link_target' ), 10, 3 );
			$this->add_experimentalfunctions();
		}


		function add_experimentalfunctions() {
			$comment = get_option( 'seohide_comment' );
			$comment = $this->option_checker( $comment );
			if ( $comment ) {
				add_filter( 'comment_text', array( $this, 'search_links' ) );
			}

			$comment_site_field = get_option( $this->option_prefix . 'comment_site_field', false );
			$comment_site_field = $this->option_checker( $comment_site_field );
			if ( $comment_site_field ) {
				add_filter( 'get_comment_author_link', array( $this, 'hide_comment_author_link' ), 10, 1 );
			}


		}

		function hide_comment_author_link( $return ) {
			$return = $this->search_links( $return );

			return $return;
		}

		function hide_comment_author_link_target( $return, $author, $comment_ID ) {
			$pos = strpos( $return, '<a ' );
			if ( is_int( $pos ) ) {
				$return = str_replace( 'href=', 'target="_blank" href=', $return );
			}
			return $return;
		}


		function  option_checker( $opt ) {

			if ( $opt == false || $opt == 0 || $opt == '0' || $opt == '' ) {
				return false;
			} elseif ( $opt == true || $opt == 1 || $opt == '1' ) {
				return true;
			}

			return true;

		}


		function set_text_domain( $var ) {
			$this->text_domain = $var;
		}

		function set_option_prefix( $var ) {
			$this->option_prefix = strval( $var );
		}

		function load_dependencies() {
			require_once plugin_dir_path( __FILE__ ) . 'includes/class-Seohide-Add-Settings-Page.php';
			$settings_page = new Seohide_Add_Settings_Page( $this->text_domain, $this->option_prefix );
		}


		function text_domine() {

			load_textdomain( $this->text_domain,	plugin_dir_path(__FILE__) . 'lang/vp-seo-hide-' . get_locale() . '.mo' );

		}

		public function load_scripts() {
			wp_register_script( 'sh', $this->settings['url'] . 'js/sh.js', array( 'jquery' ), '1.0', false );
			if ( ! is_admin() ) {
				wp_enqueue_script( 'sh' );
			}
		}

		/**
		 * @param $content string
		 *
		 * @return mixed
		 */
		function search_links( $content, $target = false ) {
			$tmp = preg_replace_callback( '/<a (.+?)>/i', array( &$this, 'links_render_cb' ), $content );

			return $tmp;
		}


		function links_render_cb( $input ) {
			if ( strpos( $input[0], site_url() ) !== false ) {
				return $input[0];
			} else {
				preg_match( '~\s(?:href)=(?:[\"\'])?(.*?)(?:[\"\'])?(?:[\s\>])~i', $input[0], $matches );
				if ( preg_match( "/^(#[a-z0-9-]{1,128}|#)/i", $matches[1] ) ) {
					return $input[0];
				}
				$input[0] = str_replace( $matches[1], $this->method_hash( $matches[1] ), $input[0] );
				$input[0] = str_replace( 'href=', "href='#' data-sh=", $input[0] );

				return $input[0];
			}
		}

		/**
		 * @param $var string
		 *
		 * @return string
		 */
		function method_hash( $var ) {
			return base64_encode( $var );
		}

	}


	function vp_seo_hide() {
		global $vp_seo_hide;
		if ( ! isset( $vp_seo_hide ) ) {
			$vp_seo_hide = new vp_seo_hide();
		}

		return $vp_seo_hide;
	}

	vp_seo_hide();
}
